integer(4) function idamax(n,dx,incx)
!
!     finds the index of element having max. absolute value.
!     jack dongarra, linpack, 3/11/78.
!     modified 3/93 to return if incx .le. 0.
!     modified 12/3/93, array(1) declarations changed to array(*)
!

real*8, dimension(*), intent(in) :: dx
real*8 :: dmax

integer(4), intent(in) :: n,incx
integer(4) :: i,ix

idamax = 0
if( n.lt.1 .or. incx.le.0 ) return
idamax = 1
if(n.eq.1)return

if(incx.ne.1) then

!  code for increment not equal to 1

	ix = 1
	dmax = abs(dx(1))
	ix = ix + incx
	do i = 2,n
	   if(abs(dx(ix)) > dmax) then
	     idamax = i
	     dmax = abs(dx(ix))
	   end if
       ix = ix + incx
    end do
return


else !  code for increment equal to 1

    dmax = abs(dx(1))
	do i = 2,n
	  if(abs(dx(i)) > dmax) then
		idamax = i
		dmax = abs(dx(i))
	  end if
    end do
end if
return
end
